<?php
/**
 * VIP
 * https://webenginecms.org/
 * 
 * @version 1.1.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="page-title"><span>'.lang('vip_title',true).'</span></div>';

try {
	
	$VIP = new \Plugin\VIP\VIP();
	$VIP->setUsername($_SESSION['username']);
	$vipButton = $VIP->isAccountVip() ? lang('vip_txt_3') : lang('vip_txt_2');
	
	if(check_value($_GET['success'])) {
		message('success', lang('vip_success_1'));
	}
	
	// VIP Info
	if($VIP->isAccountVip()) {
		$accountVipData = $VIP->getAccountVipData();
		$expirationDays = sec_to_dhms(strtotime($accountVipData[_CLMN_VIP_DATE_])-time());
		message('info', langf('vip_txt_4', array(lang('vip_title_type_'.$accountVipData[_CLMN_VIP_TYPE_]), $expirationDays[0])));
	}
	
	$vipTypeData = $VIP->getVipTypeData();
	if(!is_array($vipTypeData)) throw new Exception();
	
	foreach($vipTypeData as $vipType => $vipData) {
		if(!is_array($vipData['packages'])) continue;
		if(!$vipData['enabled']) continue;
		
		echo '<div class="col-xs-12">';
			echo '<div class="panel panel-vip type'.$vipType.'">';
				echo '<div class="panel-heading">';
					echo '<h3 class="panel-title">'.$vipData['title'].'</h3>';
				echo '</div>';
				echo '<div class="panel-body">';
					echo '<div class="row">';
						echo '<div class="col-xs-12 vip-table-container">';
							echo '<table class="table vip-table">';
								echo '<tbody>';
								foreach($vipData['packages'] as $packageId => $days) {
									
									$discountPercent = array_key_exists($packageId, $vipData['discounts']) ? $vipData['discounts'][$packageId] : 0;
									
									echo '<tr>';
										echo '<td>'.langf('vip_txt_1', array($days)).'</td>';
										if($discountPercent > 0) {
											echo '<td>'.langf('vip_txt_6', array(number_format($VIP->getVipCost($days, $vipType)), $discountPercent)).'</td>';
										} else {
											echo '<td>'.langf('vip_txt_5', array(number_format($VIP->getVipCost($days, $vipType)))).'</td>';
										}
										echo '<td><a href="'.__VIP_HOME__.'order/type/'.$vipType.'/package/'.$days.'/" class="btn btn-xs btn-vip">'.$vipButton.'</a></td>';
									echo '</tr>';
								}
								echo '</tbody>';
							echo '</table>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';
		echo '</div>';
	}
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}